<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class AdvertisementRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        $rules = [
            'title_ar' => ['required', 'string', 'max:255'],
            'title_en' => ['required', 'string', 'max:255'],
            'url' => ['required', 'string', 'max:255'],
            'status' => ['required', 'in:active,inactive'],
            'start_date' => ['nullable', 'date'],
            'end_date' => ['nullable', 'date', 'after:start_date'],
            'sort_order' => ['required', 'integer'],
            'targeted_audience' => ['required', 'in:all,male,female'],
            'targeted_language' => ['required', 'in:ar,en,both'],
        ];

        // Image validation: required on create, optional on update
        if ($this->isMethod('post')) {
            $rules['image'] = ['required', 'image', 'max:5120', 'mimes:jpeg,png,jpg,gif,webp'];
        } else {
            $rules['image'] = ['nullable', 'image', 'max:5120', 'mimes:jpeg,png,jpg,gif,webp'];
        }

        return $rules;
    }

    public function attributes(): array
    {
        return [
            'title_ar' => 'Arabic title',
            'title_en' => 'English title',
            'image' => 'image',
            'url' => 'link URL',
            'start_date' => 'start date',
            'end_date' => 'end date',
            'sort_order' => 'sort order',
            'targeted_audience' => 'targeted audience',
            'targeted_language' => 'targeted language',
        ];
    }
}
