<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class AssistantChatRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'message' => 'required|string|min:1|max:2000',
            'session_id' => 'nullable|string|max:255',
        ];
    }

    public function messages(): array
    {
        return [
            'message.required' => 'The message field is required.',
            'message.min' => 'The message must be at least 1 character.',
            'message.max' => 'The message must not exceed 2000 characters.',
            'session_id.string' => 'The session ID must be a string.',
            'session_id.max' => 'The session ID must not exceed 255 characters.',
        ];
    }
}
