<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ProfileRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'gender' => 'required|string|in:male,female,other',
            'birth_date' => 'nullable|date|before:today',
            'city' => 'nullable|string|max:255',
            'interests' => 'nullable|array',
            'interests.*' => 'string|max:100',
            'settings' => 'nullable|array',
        ];
    }
}
