<?php

namespace App\Http\Resources;

use App\Enums\Source;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ProductResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        // take first 3 words from the name if it is longer than 3 words
        $name_ar = $this->name_ar;
        if (count(explode(' ', $name_ar)) > 3) {
            $name_ar = implode(' ', array_slice(explode(' ', $name_ar), 0, 3));
        }
        $name_ar = $name_ar.'...';

        $name_en = $this->name_en;
        if (count(explode(' ', $name_en)) > 3) {
            $name_en = implode(' ', array_slice(explode(' ', $name_en), 0, 3));
        }
        $name_en = $name_en.'...';

        return [
            'id' => $this->id,
            'product_id' => $this->product_id,
            'category_id' => $this->category_id,
            'category' => [
                'id' => $this->category->id,
                'name_ar' => $this->category->name_ar,
                'name_en' => $this->category->name_en,
            ],
            'source' => $this->source,
            'source_logo' => Source::from($this->source)->logo(),
            'image_url' => $this->image_url,
            'video_url' => $this->video_url,
            'name_ar' => $name_ar,
            'name_en' => $name_en,
            'description_ar' => $this->description_ar,
            'description_en' => $this->description_en,
            'price' => $this->price,
            'discount_price' => $this->discount_price,
            'discount' => $this->discount,
            'currency' => $this->currency,
            'clicks' => $this->clicks,
            'direct_commission_rate' => $this->direct_commission_rate,
            'estimated_direct_commission' => $this->estimated_direct_commission,
            'indirect_commission_rate' => $this->indirect_commission_rate,
            'estimated_indirect_commission' => $this->estimated_indirect_commission,
            'sales_180day' => $this->sales_180day,
            'positive_feedback' => $this->positive_feedback,
            'promotion_url' => $this->promotion_url,
            'code_name' => $this->code_name,
            'code_start_time' => $this->code_start_time,
            'code_end_time' => $this->code_end_time,
            'code_value' => $this->code_value,
            'code_quantity' => $this->code_quantity,
            'code_minimum_spend' => $this->code_minimum_spend,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
