<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Category>
 */
class CategoryFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $name = fake()->unique()->word();

        return [
            'parent_id' => null,
            'name_ar' => "ال{$name}",
            'name_en' => ucfirst($name),
            'slug' => strtolower($name).'-'.fake()->unique()->randomNumber(4),
            'description_ar' => null,
            'description_en' => null,
            'image' => null,
            'status' => 'active',
            'meta_title' => null,
            'meta_description' => null,
        ];
    }
}
