<x-admin.layout title="Advertisement Details">
    <div class="mb-6">
        <div class="flex items-center justify-between">
            <h2 class="text-2xl font-bold text-gray-900 dark:text-white">Advertisement Details</h2>
            <div class="flex gap-2">
                <a href="{{ route('admin.advertisements.edit', $advertisement) }}">
                    <x-admin.form.button>
                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z" />
                        </svg>
                        Edit
                    </x-admin.form.button>
                </a>
                <form action="{{ route('admin.advertisements.destroy', $advertisement) }}" method="POST" class="inline" onsubmit="return confirm('Are you sure you want to delete this advertisement?');">
                    @csrf
                    @method('DELETE')
                    <x-admin.form.button type="submit" variant="danger">Delete</x-admin.form.button>
                </form>
            </div>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <!-- Image Preview -->
        <div class="lg:col-span-2">
            <x-admin.card title="Advertisement Image">
                @if($advertisement->image)
                    <a href="{{ $advertisement->url }}" target="_blank" class="block">
                        <img src="{{ Storage::url($advertisement->image) }}" alt="{{ $advertisement->title_en }}" class="w-full rounded-lg">
                    </a>
                @else
                    <div class="aspect-video rounded-lg bg-gray-200 dark:bg-gray-700 flex items-center justify-center">
                        <svg class="h-16 w-16 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z" />
                        </svg>
                    </div>
                @endif
                @if($advertisement->url)
                    <div class="mt-4">
                        <span class="text-sm font-medium text-gray-700 dark:text-gray-300">Link URL:</span>
                        <a href="{{ $advertisement->url }}" target="_blank" class="ml-2 text-sm text-blue-600 hover:text-blue-800 dark:text-blue-400 break-all">
                            {{ $advertisement->url }}
                        </a>
                    </div>
                @endif
            </x-admin.card>
        </div>

        <!-- Details -->
        <div class="space-y-6">
            <!-- Titles -->
            <x-admin.card title="Titles">
                <div class="space-y-4">
                    <div>
                        <span class="text-sm font-medium text-gray-500 dark:text-gray-400">English Title</span>
                        <p class="mt-1 text-lg font-medium text-gray-900 dark:text-white">{{ $advertisement->title_en }}</p>
                    </div>
                    <div>
                        <span class="text-sm font-medium text-gray-500 dark:text-gray-400">Arabic Title</span>
                        <p class="mt-1 text-lg font-medium text-gray-900 dark:text-white dir-rtl">{{ $advertisement->title_ar }}</p>
                    </div>
                </div>
            </x-admin.card>

            <!-- Status -->
            <x-admin.card title="Status & Schedule">
                <div class="space-y-4">
                    <div class="flex items-center justify-between">
                        <span class="text-sm font-medium text-gray-500 dark:text-gray-400">Status</span>
                        @if($advertisement->status === 'active')
                            <span class="px-3 py-1 text-sm font-semibold rounded-full bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-200">
                                Active
                            </span>
                        @else
                            <span class="px-3 py-1 text-sm font-semibold rounded-full bg-gray-100 text-gray-800 dark:bg-gray-700 dark:text-gray-300">
                                Inactive
                            </span>
                        @endif
                    </div>
                    <div class="flex items-center justify-between">
                        <span class="text-sm font-medium text-gray-500 dark:text-gray-400">Sort Order</span>
                        <span class="text-sm font-medium text-gray-900 dark:text-white">{{ $advertisement->sort_order }}</span>
                    </div>
                    @if($advertisement->start_date)
                        <div class="flex items-center justify-between">
                            <span class="text-sm font-medium text-gray-500 dark:text-gray-400">Start Date</span>
                            <span class="text-sm font-medium text-gray-900 dark:text-white">{{ $advertisement->start_date->format('M d, Y') }}</span>
                        </div>
                    @endif
                    @if($advertisement->end_date)
                        <div class="flex items-center justify-between">
                            <span class="text-sm font-medium text-gray-500 dark:text-gray-400">End Date</span>
                            <span class="text-sm font-medium text-gray-900 dark:text-white">{{ $advertisement->end_date->format('M d, Y') }}</span>
                        </div>
                    @endif
                    @if(!$advertisement->start_date && !$advertisement->end_date)
                        <div class="flex items-center justify-between">
                            <span class="text-sm font-medium text-gray-500 dark:text-gray-400">Schedule</span>
                            <span class="text-sm font-medium text-gray-900 dark:text-white">Always Active</span>
                        </div>
                    @endif
                </div>
            </x-admin.card>

            <!-- Targeting -->
            <x-admin.card title="Targeting">
                <div class="space-y-4">
                    <div class="flex items-center justify-between">
                        <span class="text-sm font-medium text-gray-500 dark:text-gray-400">Audience</span>
                        <span class="text-sm font-medium text-gray-900 dark:text-white">
                            @if($advertisement->targeted_audience === 'all')
                                All Users
                            @elseif($advertisement->targeted_audience === 'male')
                                Male
                            @else
                                Female
                            @endif
                        </span>
                    </div>
                    <div class="flex items-center justify-between">
                        <span class="text-sm font-medium text-gray-500 dark:text-gray-400">Language</span>
                        <span class="text-sm font-medium text-gray-900 dark:text-white">
                            @if($advertisement->targeted_language === 'both')
                                Arabic & English
                            @elseif($advertisement->targeted_language === 'ar')
                                Arabic Only
                            @else
                                English Only
                            @endif
                        </span>
                    </div>
                </div>
            </x-admin.card>

            <!-- Dates -->
            <x-admin.card title="Timestamps">
                <div class="space-y-4">
                    <div>
                        <span class="text-sm font-medium text-gray-500 dark:text-gray-400">Created</span>
                        <p class="mt-1 text-sm text-gray-900 dark:text-white">{{ $advertisement->created_at->format('M d, Y - H:i') }}</p>
                    </div>
                    <div>
                        <span class="text-sm font-medium text-gray-500 dark:text-gray-400">Last Updated</span>
                        <p class="mt-1 text-sm text-gray-900 dark:text-white">{{ $advertisement->updated_at->format('M d, Y - H:i') }}</p>
                    </div>
                </div>
            </x-admin.card>
        </div>
    </div>

    <div class="mt-6">
        <a href="{{ route('admin.advertisements.index') }}">
            <x-admin.form.button variant="outline">Back to Advertisements</x-admin.form.button>
        </a>
    </div>
</x-admin.layout>
