<!DOCTYPE html>
<html lang="en" class="h-full bg-gray-900">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Login - Octopus</title>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    <style>
        /* Animation keyframes for button border effect */
        @keyframes btn-anim1 {
            0% { left: -100%; }
            50%, 100% { left: 100%; }
        }
        @keyframes btn-anim2 {
            0% { top: -100%; }
            50%, 100% { top: 100%; }
        }
        @keyframes btn-anim3 {
            0% { right: -100%; }
            50%, 100% { right: 100%; }
        }
        @keyframes btn-anim4 {
            0% { bottom: -100%; }
            50%, 100% { bottom: 100%; }
        }

        .animate-border span:nth-child(1) {
            animation: btn-anim1 1.5s linear infinite;
        }
        .animate-border span:nth-child(2) {
            animation: btn-anim2 1.5s linear infinite;
            animation-delay: 0.375s;
        }
        .animate-border span:nth-child(3) {
            animation: btn-anim3 1.5s linear infinite;
            animation-delay: 0.75s;
        }
        .animate-border span:nth-child(4) {
            animation: btn-anim4 1.5s linear infinite;
            animation-delay: 1.125s;
        }

        /* Floating label animation */
        .user-box input:focus ~ label,
        .user-box input:not(:placeholder-shown) ~ label {
            top: -20px;
            left: 0;
            font-size: 12px;
        }
    </style>
</head>
<body class="h-full">
    <div class="absolute top-1/2 left-1/2 w-full max-w-[400px] p-10 -translate-x-1/2 -translate-y-[55%] rounded-xl bg-black/90 shadow-[0_15px_25px_rgba(0,0,0,0.6)]">
        <p class="m-0 mb-8 text-white text-center text-2xl font-bold tracking-widest">
            ADMIN LOGIN
        </p>

        <?php if($errors->any()): ?>
            <div class="mb-6 rounded bg-red-900/50 p-4 text-center text-white text-sm">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php echo e($error); ?>

                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        <?php endif; ?>

        <form action="<?php echo e(route('admin.login.submit')); ?>" method="POST">
            <?php echo csrf_field(); ?>

            <!-- Email/Phone Field -->
            <div class="user-box relative mb-8">
                <input
                    id="email"
                    name="email"
                    type="text"
                    autocomplete="username"
                    required
                    value="<?php echo e(old('email')); ?>"
                    placeholder=" "
                    class="w-full border-b border-white bg-transparent p-2.5 text-base text-white outline-none placeholder-transparent"
                >
                <label for="email" class="absolute left-0 top-0 p-2.5 text-base text-white transition-all duration-500 pointer-events-none">
                    Email / Phone
                </label>
            </div>

            <!-- Password Field -->
            <div class="user-box relative mb-8">
                <input
                    id="password"
                    name="password"
                    type="password"
                    autocomplete="current-password"
                    required
                    placeholder=" "
                    class="w-full border-b border-white bg-transparent p-2.5 text-base text-white outline-none placeholder-transparent"
                >
                <label for="password" class="absolute left-0 top-0 p-2.5 text-base text-white transition-all duration-500 pointer-events-none">
                    Password
                </label>
            </div>

            <!-- Submit Button with Animated Border -->
            <a href="javascript:void(0)" onclick="this.closest('form').submit()" class="relative inline-block w-full overflow-hidden rounded bg-transparent p-3 text-center text-base font-bold text-white uppercase no-underline transition-all duration-500 tracking-widest hover:bg-white hover:text-[#272727] hover:rounded-md animate-border">
                <span class="absolute left-0 top-0 h-[2px] w-full bg-gradient-to-r from-transparent to-white"></span>
                <span class="absolute right-0 top-0 h-full w-[2px] bg-gradient-to-b from-transparent to-white"></span>
                <span class="absolute right-0 bottom-0 h-[2px] w-full bg-gradient-to-l from-transparent to-white"></span>
                <span class="absolute left-0 bottom-0 h-full w-[2px] bg-gradient-to-t from-transparent to-white"></span>
                Login
            </a>

            <!-- Remember Me -->
            <div class="mt-10 text-center">
                <label class="flex items-center justify-center gap-2 text-white/60 text-sm">
                    <input type="checkbox" name="remember" value="1" class="rounded border-white/30 bg-transparent text-blue-500 focus:ring-blue-500 focus:ring-offset-gray-900">
                    <span>Remember me</span>
                </label>
            </div>
        </form>

        <?php if(false): ?>
        <p class="mt-8 text-center text-sm text-white/60">
            Don't have an account?
            <a href="#" class="a2 text-white no-underline hover:bg-transparent hover:text-white/60 rounded-md transition-colors">
                Sign up
            </a>
        </p>
        <?php endif; ?>
    </div>
</body>
</html>
<?php /**PATH C:\xampp0\htdocs\octopus\resources\views/auth/admin-login.blade.php ENDPATH**/ ?>