<?php

namespace Tests\Feature;

use App\AiAgents\LlmProviderFactory;
use App\AiAgents\Providers\MistralProvider;
use Illuminate\Support\Facades\Config;
use Tests\TestCase;

class MistralProviderTest extends TestCase
{
    public function test_factory_creates_mistral_provider(): void
    {
        Config::set('services.mistral.api_key', 'test-key');
        Config::set('services.mistral.api_url', 'https://api.mistral.ai/v1');
        Config::set('services.mistral.model', 'mistral-small-latest');

        $provider = LlmProviderFactory::create('mistral');

        $this->assertInstanceOf(MistralProvider::class, $provider);
        $this->assertSame('mistral', $provider->getProviderName());
        $this->assertSame('mistral-small-latest', $provider->getModel());
    }

    public function test_factory_creates_deep_seek_provider(): void
    {
        Config::set('services.deepseek.api_key', 'test-key');
        Config::set('services.deepseek.api_url', 'https://api.deepseek.com/v1');
        Config::set('services.deepseek.model', 'deepseek-chat');

        $provider = LlmProviderFactory::create('deepseek');

        $this->assertSame('deepseek', $provider->getProviderName());
        $this->assertSame('deepseek-chat', $provider->getModel());
    }

    public function test_factory_uses_default_provider_when_none_specified(): void
    {
        Config::set('services.ai.default_provider', 'mistral');
        Config::set('services.mistral.api_key', 'test-key');
        Config::set('services.mistral.api_url', 'https://api.mistral.ai/v1');
        Config::set('services.mistral.model', 'mistral-small-latest');

        $provider = LlmProviderFactory::create();

        $this->assertSame('mistral', $provider->getProviderName());
    }

    public function test_factory_throws_exception_for_invalid_provider(): void
    {
        $this->expectException(\InvalidArgumentException::class);
        $this->expectExceptionMessage('Unsupported AI provider: invalid');

        LlmProviderFactory::create('invalid');
    }
}
