<?php

namespace App\AiAgents\Contracts;

interface LlmProviderInterface
{
    /**
     * Make a chat completion request to the LLM
     *
     * @param  array<mixed>  $messages
     * @return array{choices: array<mixed>}
     */
    public function chat(array $messages): array;

    /**
     * Get the provider name for logging/metadata
     */
    public function getProviderName(): string;

    /**
     * Get the model identifier
     */
    public function getModel(): string;
}
