<?php

namespace App\AiAgents;

use App\AiAgents\Contracts\LlmProviderInterface;
use App\AiAgents\Providers\DeepSeekProvider;
use App\AiAgents\Providers\MistralProvider;
use InvalidArgumentException;

/**
 * @deprecated Use Prism\Prism\Facades\Prism for LLM interactions
 */
class LlmProviderFactory
{
    public static function create(?string $provider = null): LlmProviderInterface
    {
        $provider ??= config('services.ai.default_provider', 'deepseek');

        return match ($provider) {
            'deepseek' => new DeepSeekProvider(
                apiKey: config('services.deepseek.api_key'),
                apiUrl: config('services.deepseek.api_url'),
                model: config('services.deepseek.model')
            ),
            'mistral' => new MistralProvider(
                apiKey: config('services.mistral.api_key'),
                apiUrl: config('services.mistral.api_url'),
                model: config('services.mistral.model')
            ),
            default => throw new InvalidArgumentException("Unsupported AI provider: {$provider}"),
        };
    }
}
