<?php

namespace App\Enums;

enum Source: string
{
    case AMAZON = 'amazon';
    case EBAY = 'ebay';
    case ALIEXPRESS = 'aliexpress';
    case NOON = 'noon';
    case JUMIA = 'jumia';

    public function label(): string
    {
        return match ($this) {
            self::AMAZON => 'Amazon',
            self::EBAY => 'Ebay',
            self::ALIEXPRESS => 'AliExpress',
            self::NOON => 'Noon',
            self::JUMIA => 'Jumia',
        };
    }

    public function arabicLabel(): string
    {
        return match ($this) {
            self::AMAZON => 'أمازون',
            self::EBAY => 'إيباي',
            self::ALIEXPRESS => 'علي اكسبرس',
            self::NOON => 'نون',
            self::JUMIA => 'جوميا',
        };
    }

    public function logo(): string
    {
        return match ($this) {
            self::AMAZON => 'https://upload.wikimedia.org/wikipedia/commons/thumb/a/a9/Amazon_logo.svg/1200px-Amazon_logo.svg.png',
            self::EBAY => 'https://purepng.com/public/uploads/large/purepng.com-ebay-logologobrand-logoiconslogos-251519938326w1a5t.png',
            self::ALIEXPRESS => asset('logos/aliexpress.png'), // from the storage folder
            self::NOON => 'https://f.nooncdn.com/s/app/com/noon/design-system/logos/noon-logo-en.svg',
            self::JUMIA => 'https://logos-world.net/wp-content/uploads/2022/12/Jumia-Logo-2012.png',
        };
    }
}
