<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Services\DashboardStatsService;
use Illuminate\View\View;

class AdminDashboardController extends Controller
{
    public function __construct(
        private DashboardStatsService $dashboardStats
    ) {}

    public function index(): View
    {
        $stats = [
            'overview' => $this->dashboardStats->getOverviewStats(),
            'products_by_category' => $this->dashboardStats->getProductsByCategory(),
            'products_over_time' => $this->dashboardStats->getProductsOverTime(),
            'products_by_source' => $this->dashboardStats->getProductsBySource(),
            'price_distribution' => $this->dashboardStats->getPriceDistribution(),
            'recent_activity' => $this->dashboardStats->getRecentActivity(),
        ];

        return view('admin.dashboard.index', compact('stats'));
    }
}
