<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\View\View;

class AdminSettingsController extends Controller
{
    public function index(): View
    {
        $settings = [
            'app_name' => config('app.name', 'Octopus'),
            'app_url' => config('app.url', 'http://localhost'),
            'default_currency' => 'EGP',
            'import_batch_size' => 50,
        ];

        return view('admin.settings.index', compact('settings'));
    }

    public function update(Request $request): RedirectResponse
    {
        $request->validate([
            'app_name' => ['required', 'string', 'max:255'],
            'app_url' => ['required', 'url'],
            'default_currency' => ['required', 'in:EGP,USD,EUR'],
            'import_batch_size' => ['required', 'integer', 'min:1', 'max:100'],
        ]);

        // In a real application, you would save these to a database or config file
        // For now, we'll just show a success message

        return redirect()->route('admin.settings.index')
            ->with('success', 'Settings updated successfully.');
    }
}
