<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

final class SearchRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'q' => ['nullable', 'string', 'max:255'],
            'category' => ['nullable', 'integer', 'exists:categories,id'],
            'price_min' => ['nullable', 'numeric', 'min:0'],
            'price_max' => ['nullable', 'numeric', 'min:0'],
            'source' => ['nullable', 'string', 'in:amazon,ebay,aliexpress,noon,jumia'],
            'sort' => ['nullable', 'string', 'in:price_asc,price_desc,relevance,sales,clicks'],
            'per_page' => ['nullable', 'integer', 'min:1', 'max:50'],
            'page' => ['nullable', 'integer', 'min:1'],
        ];
    }

    /**
     * Get custom error messages for validation rules.
     *
     * @return array<string, string>
     */
    public function messages(): array
    {
        return [
            'q.max' => 'Search query is too long.',
            'category.exists' => 'The selected category does not exist.',
            'price_min.numeric' => 'Minimum price must be a valid number.',
            'price_min.min' => 'Minimum price cannot be negative.',
            'price_max.numeric' => 'Maximum price must be a valid number.',
            'price_max.min' => 'Maximum price cannot be negative.',
            'source.in' => 'The selected source is invalid.',
            'sort.in' => 'The selected sort option is invalid.',
            'per_page.integer' => 'Results per page must be a number.',
            'per_page.min' => 'Results per page must be at least 1.',
            'per_page.max' => 'Results per page cannot exceed 50.',
            'page.integer' => 'Page must be a number.',
            'page.min' => 'Page must be at least 1.',
        ];
    }
}
