<?php

declare(strict_types=1);

namespace App\Services\AiAssistant\Context;

use App\Models\Category;
use App\Models\Product;

class TenantContext
{
    public function get(): array
    {
        return [
            'current_date' => now()->toIso8601String(),
            'current_date_formatted' => now()->format('F j, Y'),
            'stats' => $this->getQuickStats(),
        ];
    }

    protected function getQuickStats(): array
    {
        return [
            'total_products' => Product::count(),
            'total_categories' => Category::count(),
            'products_with_discount' => Product::whereHasDiscount()->count(),
        ];
    }
}
