<?php

declare(strict_types=1);

namespace App\Services\AiAssistant;

class StructuredResponse
{
    public function __construct(
        public readonly string $text,
        public readonly ?string $html = null,
        public readonly ?array $metadata = null,
    ) {}

    public function toArray(): array
    {
        return array_filter([
            'text' => $this->text,
            'html' => $this->html,
            'metadata' => $this->metadata,
        ]);
    }

    public static function fromText(string $text): self
    {
        return new self(text: $text);
    }

    public static function withHtml(string $text, string $html, ?array $metadata = null): self
    {
        return new self(text: $text, html: $html, metadata: $metadata);
    }

    public function hasHtml(): bool
    {
        return $this->html !== null && $this->html !== '';
    }
}
