<?php

declare(strict_types=1);

return [
    /*
    |--------------------------------------------------------------------------
    | Prism API Configuration
    |--------------------------------------------------------------------------
    |
    | Configuration for Prism LLM providers. Credentials are sourced from
    | config/services.php for consistency across the application.
    |
    */

    'providers' => [
        'deepseek' => [
            'api_key' => env('DEEPSEEK_API_KEY'),
            'url' => env('DEEPSEEK_API_URL', 'https://api.deepseek.com/v1'),
        ],

        'mistral' => [
            'api_key' => env('MISTRAL_API_KEY'),
            'url' => env('MISTRAL_API_URL', 'https://api.mistral.ai/v1'),
        ],

        'xai' => [
            'api_key' => env('XAI_API_KEY'),
            'url' => env('XAI_URL', 'https://api.x.ai/v1'),
        ],

        'gemini' => [
            'api_key' => env('GEMINI_API_KEY'),
            'url' => env('GEMINI_URL', 'https://generativelanguage.googleapis.com/v1beta/models'),
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Default Provider
    |--------------------------------------------------------------------------
    |
    | The default LLM provider to use for AI assistant requests.
    |
    */

    'default_provider' => env('AI_DEFAULT_PROVIDER', 'deepseek'),

    /*
    |--------------------------------------------------------------------------
    | Model Configuration
    |--------------------------------------------------------------------------
    |
    | Model identifiers for each provider.
    |
    */

    'models' => [
        'deepseek' => env('DEEPSEEK_MODEL', 'deepseek-chat'),
        'mistral' => env('MISTRAL_MODEL', 'mistral-small-latest'),
        'xai' => env('XAI_MODEL', 'grok-4-fast'),
        'gemini' => env('GEMINI_MODEL', 'gemini-2.0-flash'),
    ],

    /*
    |--------------------------------------------------------------------------
    | Tool Calling Limits
    |--------------------------------------------------------------------------
    |
    | Maximum number of tool execution steps per request.
    |
    */

    'max_steps' => env('PRISM_MAX_STEPS', 5),

    /*
    |--------------------------------------------------------------------------
    | Conversation Context Limits
    |--------------------------------------------------------------------------
    |
    | Maximum number of messages to include in conversation context.
    |
    */

    'max_context_messages' => env('PRISM_MAX_CONTEXT_MESSAGES', 50),
];
