<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Advertisement>
 */
class AdvertisementFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'title_ar' => fake()->sentence(3),
            'title_en' => fake()->sentence(3),
            'image' => fake()->imageUrl(),
            'url' => fake()->url(),
            'status' => 'active',
            'start_date' => fake()->boolean(80) ? fake()->dateTimeBetween('-30 days', 'now') : null,
            'end_date' => fake()->boolean(80) ? fake()->dateTimeBetween('now', '+90 days') : null,
            'sort_order' => fake()->numberBetween(0, 100),
            'targeted_audience' => fake()->randomElement(['male', 'female', 'all']),
            'targeted_language' => fake()->randomElement(['ar', 'en', 'both']),
        ];
    }
}
