<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Product>
 */
class ProductFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $price = fake()->randomFloat(2, 50, 5000);
        $discountPrice = fake()->boolean(70) ? fake()->randomFloat(2, $price * 0.5, $price * 0.9) : null;
        $directRate = fake()->randomFloat(2, 2, 15);
        $indirectRate = fake()->randomFloat(2, 1, 8);
        $basePrice = $discountPrice ?? $price;

        return [
            'category_id' => \App\Models\Category::factory(),
            'source' => fake()->randomElement(['aliexpress', 'amazon', 'noon']),
            'name_ar' => fake()->sentence(3),
            'name_en' => fake()->sentence(3),
            'description_ar' => fake()->paragraph(3),
            'description_en' => fake()->paragraph(3),
            'price' => $price,
            'discount_price' => $discountPrice,
            'currency' => fake()->randomElement(['EGP', 'USD', 'SAR', 'AED']),
            'clicks' => fake()->numberBetween(0, 1000),
            'direct_commission_rate' => $directRate,
            'estimated_direct_commission' => $basePrice * ($directRate / 100),
            'indirect_commission_rate' => $indirectRate,
            'estimated_indirect_commission' => $basePrice * ($indirectRate / 100),
            'sales_180day' => fake()->numberBetween(0, 500),
            'positive_feedback' => fake()->randomFloat(2, 80, 100),
            'promotion_url' => fake()->url(),
            'code_name' => fake()->boolean(60) ? strtoupper(fake()->lexify('????####')) : null,
            'code_start_time' => fake()->boolean(60) ? fake()->dateTimeBetween('-30 days', '+30 days') : null,
            'code_end_time' => fake()->boolean(60) ? fake()->dateTimeBetween('+30 days', '+90 days') : null,
            'code_value' => fake()->boolean(60) ? fake()->randomFloat(2, 5, 50) : null,
            'code_quantity' => fake()->boolean(60) ? fake()->numberBetween(10, 1000) : null,
            'code_minimum_spend' => fake()->boolean(60) ? fake()->randomFloat(2, 50, 500) : null,
        ];
    }
}
