<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('search_states', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->nullable()->constrained()->onDelete('cascade');
            $table->foreignId('conversation_id')->nullable()->constrained('ai_conversations')->onDelete('cascade');
            $table->string('session_id')->nullable();
            $table->string('search_type')->default('products'); // products, deals, recommendations, etc.
            $table->json('search_params'); // Original search parameters
            $table->json('all_product_ids'); // All matching product IDs
            $table->integer('total_count')->default(0);
            $table->integer('current_page')->default(1);
            $table->integer('per_page')->default(4);
            $table->boolean('confirmed')->default(false); // User confirmed results match intent
            $table->timestamp('expires_at')->nullable();
            $table->timestamps();

            $table->index(['user_id', 'conversation_id']);
            $table->index('session_id');
            $table->index('expires_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('search_states');
    }
};
