<?php

namespace Database\Seeders;

use App\Models\Advertisement;
use Illuminate\Database\Seeder;

class AdvertisementSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $ads = [
            [
                'title_ar' => 'تخفيضات الصيف - خصم 50%',
                'title_en' => 'Summer Sale - 50% Off',
                'image' => 'https://images.unsplash.com/photo-1607082348824-0a96f2a4b9da?w=800&h=400&fit=crop',
                'url' => 'https://example.com/summer-sale',
                'status' => 'active',
                'start_date' => now()->subDays(5),
                'end_date' => now()->addDays(25),
                'sort_order' => 1,
                'targeted_audience' => 'all',
                'targeted_language' => 'both',
            ],
            [
                'title_ar' => 'مجموعة جديدة من الإلكترونيات',
                'title_en' => 'New Electronics Collection',
                'image' => 'https://images.unsplash.com/photo-1498049794561-7780e7231661?w=800&h=400&fit=crop',
                'url' => 'https://example.com/electronics',
                'status' => 'active',
                'start_date' => now(),
                'end_date' => now()->addDays(30),
                'sort_order' => 2,
                'targeted_audience' => 'all',
                'targeted_language' => 'both',
            ],
            [
                'title_ar' => 'أفضل الكتب العربية',
                'title_en' => 'Best Arabic Books',
                'image' => 'https://images.unsplash.com/photo-1512820790803-83ca734da794?w=800&h=400&fit=crop',
                'url' => 'https://example.com/arabic-books',
                'status' => 'active',
                'start_date' => now()->subDays(15),
                'end_date' => now()->addDays(60),
                'sort_order' => 7,
                'targeted_audience' => 'all',
                'targeted_language' => 'ar',
            ],
            [
                'title_ar' => 'English Books Collection',
                'title_en' => 'English Books Collection',
                'image' => 'https://images.unsplash.com/photo-1507003211169-0a1dd7228f2d?w=800&h=400&fit=crop',
                'url' => 'https://example.com/english-books',
                'status' => 'active',
                'start_date' => now()->subDays(15),
                'end_date' => now()->addDays(60),
                'sort_order' => 8,
                'targeted_audience' => 'all',
                'targeted_language' => 'en',
            ],
            [
                'title_ar' => 'ساعات رجالية أنيقة',
                'title_en' => 'Elegant Men Watches',
                'image' => 'https://images.unsplash.com/photo-1523275335684-37898b6baf30?w=800&h=400&fit=crop',
                'url' => 'https://example.com/mens-watches',
                'status' => 'active',
                'start_date' => now()->subDays(7),
                'end_date' => null,
                'sort_order' => 10,
                'targeted_audience' => 'male',
                'targeted_language' => 'both',
            ],
            [
                'title_ar' => 'ألعاب أطفال تعليمية',
                'title_en' => 'Educational Toys for Kids',
                'image' => 'https://images.unsplash.com/photo-1558060370-d644479cb6f7?w=800&h=400&fit=crop',
                'url' => 'https://example.com/kids-toys',
                'status' => 'active',
                'start_date' => now(),
                'end_date' => now()->addDays(90),
                'sort_order' => 11,
                'targeted_audience' => 'all',
                'targeted_language' => 'both',
            ],
        ];

        foreach ($ads as $ad) {
            Advertisement::create($ad);
        }
    }
}
