<x-admin.layout title="Edit Category">
    <div class="mb-6">
        <h2 class="text-2xl font-bold text-gray-900 dark:text-white">Edit Category</h2>
    </div>

    <div class="max-w-2xl">
        <x-admin.card>
            <form action="{{ route('admin.categories.update', $category) }}" method="POST" enctype="multipart/form-data">
                @csrf
                @method('PUT')

                <x-admin.form.select
                    name="parent_id"
                    label="Parent Category (Optional)"
                    :options="$parentCategories->pluck('name_en', 'id')"
                    :value="$category->parent_id"
                    placeholder="None - Top Level Category"
                />

                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <x-admin.form.input name="name_en" label="Name (English)" :value="$category->name_en" required />
                    <x-admin.form.input name="name_ar" label="Name (Arabic)" :value="$category->name_ar" required />
                </div>

                <x-admin.form.input
                    name="slug"
                    label="Slug"
                    :value="$category->slug"
                    required
                    help="URL-friendly version (e.g., electronics)"
                />

                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <x-admin.form.textarea name="description_en" label="Description (English)" :value="$category->description_en" rows="3" />
                    <x-admin.form.textarea name="description_ar" label="Description (Arabic)" :value="$category->description_ar" rows="3" />
                </div>

                <!-- Image Upload Section -->
                <div class="mb-4">
                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                        Category Image
                    </label>

                    @if($category->image)
                        <div class="mb-3">
                            <p class="text-sm text-gray-500 dark:text-gray-400 mb-2">Current Image:</p>
                            <img src="{{ asset($category->image) }}" alt="{{ $category->name_en }}" class="h-20 w-20 rounded object-cover border border-gray-200 dark:border-gray-700">
                        </div>
                    @endif

                    <div class="flex gap-4 mb-3">
                        <label class="flex-1">
                            <input type="radio" name="image_type" value="url" @if(!str_starts_with($category->image ?? '', 'storage/')) checked @endif class="mr-2" onchange="toggleImageInput('url')">
                            <span class="text-sm text-gray-700 dark:text-gray-300">Image URL</span>
                        </label>
                        <label class="flex-1">
                            <input type="radio" name="image_type" value="upload" @if(str_starts_with($category->image ?? '', 'storage/')) checked @endif class="mr-2" onchange="toggleImageInput('upload')">
                            <span class="text-sm text-gray-700 dark:text-gray-300">Upload File</span>
                        </label>
                    </div>

                    <div id="image-url-input" class="mb-3 @if(str_starts_with($category->image ?? '', 'storage/')) hidden @endif">
                        <x-admin.form.input name="image_url" label="Image URL" type="url" :value="$category->image" placeholder="https://example.com/image.jpg" />
                    </div>

                    <div id="image-file-input" class="mb-3 @if(!str_starts_with($category->image ?? '', 'storage/')) hidden @endif">
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Upload Image
                        </label>
                        <input type="file" name="image_file" accept="image/jpeg,image/png,image/jpg,image/gif,image/webp"
                               class="block w-full text-sm text-gray-500 dark:text-gray-400
                                      file:mr-4 file:py-2.5 file:px-4
                                      file:rounded-md file:border-0
                                      file:text-sm file:font-semibold
                                      file:bg-blue-50 file:text-blue-700
                                      hover:file:bg-blue-100
                                      dark:file:bg-blue-900 dark:file:text-blue-200
                                      cursor-pointer rounded-md">
                        <p class="mt-1 text-sm text-gray-500 dark:text-gray-400">Accepted formats: JPEG, PNG, GIF, WebP (Max 2MB)</p>
                    </div>
                </div>

                <x-admin.form.select
                    name="status"
                    label="Status"
                    :options="['active' => 'Active', 'inactive' => 'Inactive']"
                    :value="$category->status"
                    required
                />

                <div class="border-t border-gray-200 dark:border-gray-700 pt-6 mt-6">
                    <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">SEO Settings</h3>

                    <x-admin.form.input name="meta_title" label="Meta Title" :value="$category->meta_title" />
                    <x-admin.form.textarea name="meta_description" label="Meta Description" :value="$category->meta_description" rows="2" />
                </div>

                <div class="mt-6 flex items-center justify-end gap-3">
                    <a href="{{ route('admin.categories.index') }}">
                        <x-admin.form.button type="button" variant="outline">Cancel</x-admin.form.button>
                    </a>
                    <x-admin.form.button type="submit">Update Category</x-admin.form.button>
                </div>
            </form>
        </x-admin.card>
    </div>
</x-admin.layout>

<script>
    // Auto-generate slug from name_en
    document.getElementById('name_en').addEventListener('input', function(e) {
        const slug = e.target.value
            .toLowerCase()
            .replace(/[^a-z0-9]+/g, '-')
            .replace(/^-+|-+$/g, '');
        document.getElementById('slug').value = slug;
    });

    // Toggle image input type
    function toggleImageInput(type) {
        const urlInput = document.getElementById('image-url-input');
        const fileInput = document.getElementById('image-file-input');
        const urlField = document.querySelector('input[name="image_url"]');
        const fileField = document.querySelector('input[name="image_file"]');

        if (type === 'url') {
            urlInput.classList.remove('hidden');
            fileInput.classList.add('hidden');
            urlField.required = false;
            fileField.required = false;
        } else {
            urlInput.classList.add('hidden');
            fileInput.classList.remove('hidden');
            urlField.required = false;
            fileField.required = false;
        }
    }
</script>
