@props([
    'title',
    'value',
    'icon' => null,
    'trend' => null,
    'trendValue' => null,
    'color' => 'blue'
])

@php
$colorClasses = [
    'blue' => 'bg-blue-50 text-blue-600 dark:bg-blue-900 dark:text-blue-200',
    'green' => 'bg-green-50 text-green-600 dark:bg-green-900 dark:text-green-200',
    'red' => 'bg-red-50 text-red-600 dark:bg-red-900 dark:text-red-200',
    'yellow' => 'bg-yellow-50 text-yellow-600 dark:bg-yellow-900 dark:text-yellow-200',
    'purple' => 'bg-purple-50 text-purple-600 dark:bg-purple-900 dark:text-purple-200',
];

$trendClasses = [
    'up' => 'text-green-600 dark:text-green-400',
    'down' => 'text-red-600 dark:text-red-400',
    'neutral' => 'text-gray-600 dark:text-gray-400',
];
@endphp

<div class="bg-white dark:bg-gray-800 border border-gray-200 dark:border-gray-700 rounded-lg shadow-sm p-6">
    <div class="flex items-center justify-between">
        <div class="flex-1">
            <p class="text-sm font-medium text-gray-600 dark:text-gray-400">{{ $title }}</p>
            <p class="mt-2 text-3xl font-bold text-gray-900 dark:text-white">{{ $value }}</p>

            @if($trend && $trendValue)
                <div class="mt-2 flex items-center gap-1 text-sm {{ $trendClasses[$trend] ?? $trendClasses['neutral'] }}">
                    @if($trend === 'up')
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 10l7-7m0 0l7 7m-7-7v18" />
                        </svg>
                    @elseif($trend === 'down')
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 14l-7 7m0 0l-7-7m7 7V3" />
                        </svg>
                    @endif
                    <span>{{ $trendValue }}</span>
                </div>
            @endif
        </div>

        @if($icon)
            <div class="flex h-12 w-12 items-center justify-center rounded-lg {{ $colorClasses[$color] ?? $colorClasses['blue'] }}">
                {!! $icon !!}
            </div>
        @endif
    </div>
</div>
