@props(['categories'])

<div class="ai-category-grid">
    <div class="grid grid-cols-2 sm:grid-cols-3 md:grid-cols-4 gap-3">
        @forelse($categories as $category)
            <div class="ai-category-card group bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 overflow-hidden hover:shadow-md hover:border-gray-300 dark:hover:border-gray-600 transition-all cursor-pointer">
                @if($category->icon)
                    <div class="p-4 bg-gradient-to-br from-gray-50 to-gray-100 dark:from-gray-700 dark:to-gray-800 flex items-center justify-center">
                        <span class="text-3xl">{!! $category->icon !!}</span>
                    </div>
                @elseif($category->image)
                    <div class="p-4 bg-gradient-to-br from-gray-50 to-gray-100 dark:from-gray-700 dark:to-gray-800 flex items-center justify-center">
                        <img src="{{ $category->image }}" alt="{{ $category->name_en }}" class="w-12 h-12 object-cover rounded">
                    </div>
                @else
                    <div class="p-4 bg-gradient-to-br from-gray-50 to-gray-100 dark:from-gray-700 dark:to-gray-800 flex items-center justify-center">
                        <svg class="w-10 h-10 text-gray-400 dark:text-gray-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10" />
                        </svg>
                    </div>
                @endif

                <div class="p-3">
                    <h4 class="text-sm font-medium text-gray-900 dark:text-white truncate text-center">
                        {{ $category->name_en }}
                    </h4>
                    @php
                        $productCount = $category->products_count ?? $category->products()->count();
                    @endphp
                    <p class="text-xs text-gray-500 dark:text-gray-400 text-center mt-1">
                        {{ $productCount }} {{ $productCount === 1 ? 'product' : 'products' }}
                    </p>
                </div>
            </div>
        @empty
            <div class="col-span-full text-center py-6 text-gray-500 dark:text-gray-400 text-sm">
                No categories found
            </div>
        @endforelse
    </div>
</div>
