@props(['product', 'badge' => null, 'locale' => 'en'])

@php
    $isArabic = $locale === 'ar';
    $nameField = $isArabic && $product->name_ar ? $product->name_ar : $product->name_en;
    $categoryName = $product->category ? ($isArabic && $product->category->name_ar ? $product->category->name_ar : $product->category->name_en) : null;
    $currencySymbol = $isArabic ? 'جنيه' : 'EGP';
@endphp

<a href="{{ $product->promotion_url ?? '#' }}" target="_blank" rel="noopener noreferrer" class="block ai-product-card bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 overflow-hidden hover:shadow-md hover:border-blue-300 dark:hover:border-blue-600 transition-all cursor-pointer" dir="{{ $isArabic ? 'rtl' : 'ltr' }}">
    @if($badge)
        <div class="ai-product-badge absolute top-2 right-2 px-2 py-1 text-xs font-semibold rounded-full bg-gradient-to-r from-purple-500 to-pink-500 text-white">
            {{ $badge }}
        </div>
    @endif

    <div class="flex gap-3 p-3">
        @if($product->image_url)
            <div class="flex-shrink-0 w-16 h-16 bg-gray-100 dark:bg-gray-700 rounded-lg overflow-hidden">
                <img src="{{ $product->image_url }}" alt="{{ $nameField }}" class="w-full h-full object-cover">
            </div>
        @else
            <div class="flex-shrink-0 w-16 h-16 bg-gray-100 dark:bg-gray-700 rounded-lg flex items-center justify-center">
                <svg class="w-8 h-8 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4" />
                </svg>
            </div>
        @endif

        <div class="flex-1 min-w-0">
            <h4 class="text-sm font-semibold text-gray-900 dark:text-white truncate">
                {{ $nameField }}
            </h4>

            @if($categoryName)
                <p class="text-xs text-gray-500 dark:text-gray-400 mt-0.5">
                    {{ $categoryName }}
                </p>
            @endif

            <div class="flex items-center gap-2 mt-2">
                <div class="flex items-center gap-1">
                    @if($product->discount_price)
                        <span class="text-sm font-bold text-green-600 dark:text-green-400">
                            {{ number_format($product->discount_price, 2) }} {{ $currencySymbol }}
                        </span>
                        <span class="text-xs text-gray-400 line-through">
                            {{ number_format($product->price, 2) }} {{ $currencySymbol }}
                        </span>
                    @else
                        <span class="text-sm font-bold text-gray-900 dark:text-white">
                            {{ number_format($product->price, 2) }} {{ $currencySymbol }}
                        </span>
                    @endif
                </div>

                @if($product->discount > 0)
                    <span class="px-1.5 py-0.5 text-xs font-medium rounded bg-red-100 dark:bg-red-900/30 text-red-600 dark:text-red-400">
                        -{{ number_format($product->discount, 0) }}%
                    </span>
                @endif
            </div>

            <div class="flex items-center gap-3 mt-2 text-xs text-gray-500 dark:text-gray-400">
                <span class="flex items-center gap-1">
                    <svg class="w-3.5 h-3.5 text-yellow-400" fill="currentColor" viewBox="0 0 20 20">
                        <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z" />
                    </svg>
                    {{ number_format($product->positive_feedback, 0) }}%
                </span>
                <span class="flex items-center gap-1">
                    <svg class="w-3.5 h-3.5 text-blue-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z" />
                    </svg>
                    {{ $product->sales_180day ?? 0 }} {{ $isArabic ? 'بيع' : 'sold' }}
                </span>
            </div>
        </div>
    </div>
</a>
