<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag;

$__newAttributes = [];
$__propNames = \Illuminate\View\ComponentAttributeBag::extractPropNames((['product', 'badge' => null, 'locale' => 'en']));

foreach ($attributes->all() as $__key => $__value) {
    if (in_array($__key, $__propNames)) {
        $$__key = $$__key ?? $__value;
    } else {
        $__newAttributes[$__key] = $__value;
    }
}

$attributes = new \Illuminate\View\ComponentAttributeBag($__newAttributes);

unset($__propNames);
unset($__newAttributes);

foreach (array_filter((['product', 'badge' => null, 'locale' => 'en']), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
}

$__defined_vars = get_defined_vars();

foreach ($attributes->all() as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
}

unset($__defined_vars, $__key, $__value); ?>

<?php
    $isArabic = $locale === 'ar';
    $nameField = $isArabic && $product->name_ar ? $product->name_ar : $product->name_en;
    $categoryName = $product->category ? ($isArabic && $product->category->name_ar ? $product->category->name_ar : $product->category->name_en) : null;
    $currencySymbol = $isArabic ? 'جنيه' : 'EGP';
?>

<a href="<?php echo e($product->promotion_url ?? '#'); ?>" target="_blank" rel="noopener noreferrer" class="block ai-product-card bg-white dark:bg-gray-800 rounded-lg border border-gray-200 dark:border-gray-700 overflow-hidden hover:shadow-md hover:border-blue-300 dark:hover:border-blue-600 transition-all cursor-pointer" dir="<?php echo e($isArabic ? 'rtl' : 'ltr'); ?>">
    <?php if($badge): ?>
        <div class="ai-product-badge absolute top-2 right-2 px-2 py-1 text-xs font-semibold rounded-full bg-gradient-to-r from-purple-500 to-pink-500 text-white">
            <?php echo e($badge); ?>

        </div>
    <?php endif; ?>

    <div class="flex gap-3 p-3">
        <?php if($product->image_url): ?>
            <div class="flex-shrink-0 w-16 h-16 bg-gray-100 dark:bg-gray-700 rounded-lg overflow-hidden">
                <img src="<?php echo e($product->image_url); ?>" alt="<?php echo e($nameField); ?>" class="w-full h-full object-cover">
            </div>
        <?php else: ?>
            <div class="flex-shrink-0 w-16 h-16 bg-gray-100 dark:bg-gray-700 rounded-lg flex items-center justify-center">
                <svg class="w-8 h-8 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4" />
                </svg>
            </div>
        <?php endif; ?>

        <div class="flex-1 min-w-0">
            <h4 class="text-sm font-semibold text-gray-900 dark:text-white truncate">
                <?php echo e($nameField); ?>

            </h4>

            <?php if($categoryName): ?>
                <p class="text-xs text-gray-500 dark:text-gray-400 mt-0.5">
                    <?php echo e($categoryName); ?>

                </p>
            <?php endif; ?>

            <div class="flex items-center gap-2 mt-2">
                <div class="flex items-center gap-1">
                    <?php if($product->discount_price): ?>
                        <span class="text-sm font-bold text-green-600 dark:text-green-400">
                            <?php echo e(number_format($product->discount_price, 2)); ?> <?php echo e($currencySymbol); ?>

                        </span>
                        <span class="text-xs text-gray-400 line-through">
                            <?php echo e(number_format($product->price, 2)); ?> <?php echo e($currencySymbol); ?>

                        </span>
                    <?php else: ?>
                        <span class="text-sm font-bold text-gray-900 dark:text-white">
                            <?php echo e(number_format($product->price, 2)); ?> <?php echo e($currencySymbol); ?>

                        </span>
                    <?php endif; ?>
                </div>

                <?php if($product->discount > 0): ?>
                    <span class="px-1.5 py-0.5 text-xs font-medium rounded bg-red-100 dark:bg-red-900/30 text-red-600 dark:text-red-400">
                        -<?php echo e(number_format($product->discount, 0)); ?>%
                    </span>
                <?php endif; ?>
            </div>

            <div class="flex items-center gap-3 mt-2 text-xs text-gray-500 dark:text-gray-400">
                <span class="flex items-center gap-1">
                    <svg class="w-3.5 h-3.5 text-yellow-400" fill="currentColor" viewBox="0 0 20 20">
                        <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z" />
                    </svg>
                    <?php echo e(number_format($product->positive_feedback, 0)); ?>%
                </span>
                <span class="flex items-center gap-1">
                    <svg class="w-3.5 h-3.5 text-blue-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z" />
                    </svg>
                    <?php echo e($product->sales_180day ?? 0); ?> <?php echo e($isArabic ? 'بيع' : 'sold'); ?>

                </span>
            </div>
        </div>
    </div>
</a>
<?php /**PATH C:\xampp0\htdocs\octopus\resources\views/components/ai/product-card.blade.php ENDPATH**/ ?>