<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag;

$__newAttributes = [];
$__propNames = \Illuminate\View\ComponentAttributeBag::extractPropNames((['product', 'dealType']));

foreach ($attributes->all() as $__key => $__value) {
    if (in_array($__key, $__propNames)) {
        $$__key = $$__key ?? $__value;
    } else {
        $__newAttributes[$__key] = $__value;
    }
}

$attributes = new \Illuminate\View\ComponentAttributeBag($__newAttributes);

unset($__propNames);
unset($__newAttributes);

foreach (array_filter((['product', 'dealType']), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
}

$__defined_vars = get_defined_vars();

foreach ($attributes->all() as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
}

unset($__defined_vars, $__key, $__value); ?>

<?php
    $dealConfig = [
        'best' => ['label' => 'Best Deal', 'color' => 'green', 'icon' => 'star'],
        'flash' => ['label' => 'Flash Sale', 'color' => 'red', 'icon' => 'lightning'],
        'coupon' => ['label' => 'Coupon', 'color' => 'blue', 'icon' => 'tag'],
        'value' => ['label' => 'Great Value', 'color' => 'purple', 'icon' => 'sparkles'],
    ];

    $config = $dealConfig[$dealType] ?? $dealConfig['best'];
?>

<a href="<?php echo e(route('admin.products.edit', $product->id)); ?>" class="block ai-deal-card bg-white dark:bg-gray-800 rounded-lg border-2 border-<?php echo e($config['color']); ?>-500 dark:border-<?php echo e($config['color']); ?>-600 overflow-hidden relative hover:shadow-md transition-all cursor-pointer">
    
    <div class="absolute top-2 left-2 px-2 py-1 text-xs font-bold rounded-full bg-<?php echo e($config['color']); ?>-500 text-white flex items-center gap-1">
        <?php if($config['icon'] === 'lightning'): ?>
            <svg class="w-3 h-3" fill="currentColor" viewBox="0 0 20 20"><path d="M11.3 1.046A1 1 0 0112 2v5h4a1 1 0 01.82 1.573l-7 10A1 1 0 018 18v-5H4a1 1 0 01-.82-1.573l7-10a1 1 0 011.12-.38z"/></svg>
        <?php elseif($config['icon'] === 'star'): ?>
            <svg class="w-3 h-3" fill="currentColor" viewBox="0 0 20 20"><path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/></svg>
        <?php elseif($config['icon'] === 'tag'): ?>
            <svg class="w-3 h-3" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M5 2a1 1 0 011 1v1h1a1 1 0 010 2H6v1a1 1 0 01-2 0V6H3a1 1 0 010-2h1V3a1 1 0 011-1zm0 10a1 1 0 011 1v1h1a1 1 0 110 2H6v1a1 1 0 11-2 0v-1H3a1 1 0 110-2h1v-1a1 1 0 011-1zM12 2a1 1 0 01.967.744L14.146 7.2 17.5 9.134a1 1 0 010 1.732l-3.354 1.935-1.18 4.455a1 1 0 01-1.933 0L9.854 12.8 6.5 10.866a1 1 0 010-1.732l3.354-1.935 1.18-4.455A1 1 0 0112 2z" clip-rule="evenodd"/></svg>
        <?php else: ?>
            <svg class="w-3 h-3" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M5 2a1 1 0 011 1v1h1a1 1 0 010 2H6v1a1 1 0 01-2 0V6H3a1 1 0 010-2h1V3a1 1 0 011-1zm0 10a1 1 0 011 1v1h1a1 1 0 110 2H6v1a1 1 0 11-2 0v-1H3a1 1 0 110-2h1v-1a1 1 0 011-1zM12 2a1 1 0 01.967.744L14.146 7.2 17.5 9.134a1 1 0 010 1.732l-3.354 1.935-1.18 4.455a1 1 0 01-1.933 0L9.854 12.8 6.5 10.866a1 1 0 010-1.732l3.354-1.935 1.18-4.455A1 1 0 0112 2z"/></svg>
        <?php endif; ?>
        <?php echo e($config['label']); ?>

    </div>

    <div class="flex gap-3 p-3">
        <?php if($product->image_url): ?>
            <div class="flex-shrink-0 w-20 h-20 bg-gray-100 dark:bg-gray-700 rounded-lg overflow-hidden">
                <img src="<?php echo e($product->image_url); ?>" alt="<?php echo e($product->name_en); ?>" class="w-full h-full object-cover">
            </div>
        <?php else: ?>
            <div class="flex-shrink-0 w-20 h-20 bg-gray-100 dark:bg-gray-700 rounded-lg flex items-center justify-center">
                <svg class="w-10 h-10 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4" />
                </svg>
            </div>
        <?php endif; ?>

        <div class="flex-1 min-w-0">
            <h4 class="text-sm font-semibold text-gray-900 dark:text-white truncate">
                <?php echo e($product->name_en); ?>

            </h4>

            <?php if($product->category): ?>
                <p class="text-xs text-gray-500 dark:text-gray-400 mt-0.5">
                    <?php echo e($product->category->name_en); ?>

                </p>
            <?php endif; ?>

            
            <div class="flex items-center gap-2 mt-2">
                <?php if($product->discount_price): ?>
                    <div class="flex items-baseline gap-1">
                        <span class="text-lg font-bold text-green-600 dark:text-green-400">
                            $<?php echo e(number_format($product->discount_price, 2)); ?>

                        </span>
                        <span class="text-xs text-gray-400 line-through">
                            $<?php echo e(number_format($product->price, 2)); ?>

                        </span>
                    </div>
                    <span class="px-2 py-0.5 text-xs font-bold rounded bg-red-500 text-white">
                        Save <?php echo e(number_format($product->discount, 0)); ?>%
                    </span>
                    <?php
                        $savings = $product->price - $product->discount_price;
                    ?>
                    <span class="text-xs text-green-600 dark:text-green-400 font-medium">
                        ($<?php echo e(number_format($savings, 2)); ?> off)
                    </span>
                <?php else: ?>
                    <span class="text-lg font-bold text-gray-900 dark:text-white">
                        $<?php echo e(number_format($product->price, 2)); ?>

                    </span>
                <?php endif; ?>
            </div>

            
            <?php if($product->code_name): ?>
                <div class="mt-2 flex items-center gap-2">
                    <span class="px-2 py-0.5 text-xs font-medium rounded bg-blue-100 dark:bg-blue-900/30 text-blue-600 dark:text-blue-400 flex items-center gap-1">
                        <svg class="w-3 h-3" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M5 2a1 1 0 011 1v1h1a1 1 0 010 2H6v1a1 1 0 01-2 0V6H3a1 1 0 010-2h1V3a1 1 0 011-1zm0 10a1 1 0 011 1v1h1a1 1 0 110 2H6v1a1 1 0 11-2 0v-1H3a1 1 0 110-2h1v-1a1 1 0 011-1zM12 2a1 1 0 01.967.744L14.146 7.2 17.5 9.134a1 1 0 010 1.732l-3.354 1.935-1.18 4.455a1 1 0 01-1.933 0L9.854 12.8 6.5 10.866a1 1 0 010-1.732l3.354-1.935 1.18-4.455A1 1 0 0112 2z" clip-rule="evenodd"/>
                        </svg>
                        Code: <?php echo e($product->code_name); ?>

                    </span>
                    <?php if($product->code_value > 0): ?>
                        <span class="text-xs text-gray-500 dark:text-gray-400">
                            Save $<?php echo e(number_format($product->code_value, 2)); ?>

                        </span>
                    <?php endif; ?>
                </div>
            <?php endif; ?>

            <div class="flex items-center gap-3 mt-2 text-xs text-gray-500 dark:text-gray-400">
                <span class="flex items-center gap-1">
                    <svg class="w-3.5 h-3.5 text-yellow-400" fill="currentColor" viewBox="0 0 20 20">
                        <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z" />
                    </svg>
                    <?php echo e(number_format($product->positive_feedback, 0)); ?>%
                </span>
                <span class="flex items-center gap-1">
                    <svg class="w-3.5 h-3.5 text-blue-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z" />
                    </svg>
                    <?php echo e($product->sales_180day ?? 0); ?> sold
                </span>
            </div>
        </div>
    </div>
</a>
<?php /**PATH C:\xampp0\htdocs\octopus\resources\views/components/ai/deal-card.blade.php ENDPATH**/ ?>