<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('products', function (Blueprint $table) {
            $table->id();
            $table->foreignId('category_id')->constrained('categories')->cascadeOnDelete();
            $table->string('source');
            $table->string('name_ar');
            $table->string('name_en');
            $table->text('description_ar');
            $table->text('description_en');
            $table->string('image_url')->nullable();
            $table->string('video_url')->nullable();
            $table->decimal('price', 10, 2)->nullable();
            $table->decimal('discount_price', 10, 2)->nullable();
            $table->string('currency', 3)->default('EGP');
            $table->unsignedBigInteger('clicks')->default(0);
            $table->decimal('direct_commission_rate', 8, 2)->nullable();
            $table->decimal('estimated_direct_commission', 10, 2)->nullable();
            $table->decimal('indirect_commission_rate', 8, 2)->nullable();
            $table->decimal('estimated_indirect_commission', 10, 2)->nullable();
            $table->unsignedBigInteger('sales_180day')->default(0);
            $table->decimal('positive_feedback', 5, 2)->nullable();
            $table->string('promotion_url')->nullable();
            $table->string('code_name')->nullable();
            $table->dateTime('code_start_time')->nullable();
            $table->dateTime('code_end_time')->nullable();
            $table->decimal('code_value', 10, 2)->nullable();
            $table->unsignedBigInteger('code_quantity')->nullable();
            $table->decimal('code_minimum_spend', 10, 2)->nullable();
            $table->timestamps();
            $table->softDeletes();
        });

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('products');
    }
};
