<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Str;

class CategorySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $parentCategories = [
            ['name_en' => 'Electronics', 'name_ar' => 'الإلكترونيات'],
            ['name_en' => 'Home', 'name_ar' => 'المنزل'],
            ['name_en' => 'Fashion & Apparel', 'name_ar' => 'الموضة والملابس'],
            ['name_en' => 'Beauty & Health', 'name_ar' => 'الجمال والصحة'],
            ['name_en' => 'Sports & Entertainment', 'name_ar' => 'الرياضة والترفيه'],
            ['name_en' => 'Automotive', 'name_ar' => 'السيارات'],
            ['name_en' => 'General & Miscellaneous', 'name_ar' => 'عام ومتنوع'],
        ];

        $subCategories = [
            // Electronics & Technology
            'Electronics & Technology' => [
                ['name_en' => 'Consumer Electronics', 'name_ar' => 'الإلكترونيات الاستهلاكية'],
                ['name_en' => 'Phones & Telecommunications', 'name_ar' => 'الهواتف والاتصالات'],
                ['name_en' => 'Computer & Office', 'name_ar' => 'الكمبيوتر ومستلزمات المكتب'],
                ['name_en' => 'Electronic Components & Supplies', 'name_ar' => 'المكونات واللوازم الإلكترونية'],
                ['name_en' => 'Phones & Telecommunications Accessories', 'name_ar' => 'إكسسوارات الهواتف والاتصالات'],
            ],
            // Home & Living
            'Home & Living' => [
                ['name_en' => 'Home Appliances', 'name_ar' => 'الأجهزة المنزلية'],
                ['name_en' => 'Home Improvement', 'name_ar' => 'تحسين المنزل'],
                ['name_en' => 'Home & Garden', 'name_ar' => 'المنزل والحديقة'],
                ['name_en' => 'Furniture', 'name_ar' => 'الأثاث'],
                ['name_en' => 'Lights & Lighting', 'name_ar' => 'الإضاءة والإنارة'],
                ['name_en' => 'Security & Protection', 'name_ar' => 'الأمن والحماية'],
                ['name_en' => 'Tools', 'name_ar' => 'الأدوات'],
            ],
            // Fashion & Apparel
            'Fashion & Apparel' => [
                ['name_en' => 'Clothing & Apparel', 'name_ar' => 'الملابس'],
                ['name_en' => 'Men\'s Clothing', 'name_ar' => 'ملابس رجالية'],
                ['name_en' => 'Shoes', 'name_ar' => 'الأحذية'],
                ['name_en' => 'Sports Shoes, Clothing & Accessories', 'name_ar' => 'الأحذية الرياضية والملابس والإكسسوارات'],
                ['name_en' => 'Underwear', 'name_ar' => 'الملابس الداخلية'],
                ['name_en' => 'Apparel Accessories', 'name_ar' => 'إكسسوارات الملابس'],
                ['name_en' => 'Jewelry & Accessories', 'name_ar' => 'المجوهرات والإكسسوارات'],
                ['name_en' => 'Watches', 'name_ar' => 'الساعات'],
                ['name_en' => 'Luggage & Bags', 'name_ar' => 'الحقائب وأمتعة السفر'],
            ],
            // Beauty & Health
            'Beauty & Health' => [
                ['name_en' => 'Health & Personal Care', 'name_ar' => 'الصحة والعناية الشخصية'],
                ['name_en' => 'Mother & Kids', 'name_ar' => 'الأم والطفل'],
            ],
            // Sports & Entertainment
            'Sports & Entertainment' => [
                ['name_en' => 'Entertainment', 'name_ar' => 'الترفيه'],
                ['name_en' => 'Toys & Hobbies', 'name_ar' => 'الألعاب والهوايات'],
            ],
            // Automotive
            'Automotive' => [
                ['name_en' => 'Car Parts & Accessories', 'name_ar' => 'قطع غيار وإكسسوارات السيارات'],
                ['name_en' => 'Motorcycle Equipments & Parts', 'name_ar' => 'معدات وقطع غيار الدراجات النارية'],
            ],
            // General & Miscellaneous
            'General & Miscellaneous' => [
                ['name_en' => 'Food & Beverages', 'name_ar' => 'الطعام والمشروبات'],
                ['name_en' => 'Office & School Supplies', 'name_ar' => 'لوازم المكتب والمدرسة'],
                ['name_en' => 'Virtual Products', 'name_ar' => 'المنتجات الرقمية'],
                ['name_en' => 'Industrial & Business', 'name_ar' => 'الصناعة والأعمال'],
                ['name_en' => 'Weddings & Events', 'name_ar' => 'حفلات الزفاف والمناسبات'],
                ['name_en' => 'Books & Cultural Merchandise', 'name_ar' => 'الكتب والمنتجات الثقافية'],
                ['name_en' => 'Novelty & Special Use', 'name_ar' => 'منتجات مبتكرة واستخدامات خاصة'],
                ['name_en' => 'Special Category', 'name_ar' => 'فئة خاصة'],
            ],
        ];

        foreach ($parentCategories as $parentCategory) {
            $parent = \App\Models\Category::create([
                'parent_id' => null,
                'name_en' => $parentCategory['name_en'],
                'name_ar' => $parentCategory['name_ar'],
                'slug' => Str::slug($parentCategory['name_en']),
                'status' => 'active',
            ]);

            if (isset($subCategories[$parentCategory['name_en']])) {
                foreach ($subCategories[$parentCategory['name_en']] as $subCategory) {
                    \App\Models\Category::create([
                        'parent_id' => $parent->id,
                        'name_en' => $subCategory['name_en'],
                        'name_ar' => $subCategory['name_ar'],
                        'slug' => Str::slug($subCategory['name_en']),
                        'status' => 'active',
                    ]);
                }
            }
        }
    }
}
