<?php

use App\Http\Controllers\API\V1\AssistantController;
use App\Http\Controllers\API\V1\AuthController;
use App\Http\Controllers\API\V1\FavouriteController;
use App\Http\Controllers\API\V1\ProductController;
use App\Http\Controllers\API\V1\ProfileController;
use App\Http\Controllers\API\V1\RegisterController;
use App\Http\Controllers\API\V1\SettingsController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

// Public routes (v1)
Route::prefix('v1')->group(function () {
    Route::post('/register', [RegisterController::class, 'register']);
    Route::post('/login', [AuthController::class, 'login']);
    Route::post('/forgot-password', [AuthController::class, 'forgotPassword'])->middleware('throttle:5,1');
    Route::post('/reset-password', [AuthController::class, 'resetPassword'])->middleware('throttle:5,1');
    Route::apiResource('/categories', \App\Http\Controllers\API\V1\CategoryController::class, ['only' => ['index', 'show']]);
    Route::get('/products', [ProductController::class, 'index']);
    Route::apiResource('/advertisements', \App\Http\Controllers\API\V1\AdvertisementController::class, ['only' => ['index']]);
    Route::get('/home', [\App\Http\Controllers\API\V1\HomeController::class, 'index']);

    // AI Assistant routes (guest users with rate limiting)
    Route::post('/assistant/chat', [AssistantController::class, 'chat'])->middleware('throttle:10,1');
    Route::get('/assistant/suggestions', [AssistantController::class, 'getSuggestions'])->middleware('throttle:20,1');
});

// Protected routes (v1)
Route::prefix('v1')->middleware('auth:sanctum')->group(function () {
    Route::post('/logout', [AuthController::class, 'logout']);
    Route::get('/user', [AuthController::class, 'user']);

    // Profile routes
    Route::post('/profile', [ProfileController::class, 'store']);
    Route::get('/profile', [ProfileController::class, 'show']);
    Route::put('/profile', [ProfileController::class, 'update']);

    // Settings routes
    Route::get('/settings', [SettingsController::class, 'show']);
    Route::put('/settings', [SettingsController::class, 'update']);
    Route::patch('/settings', [SettingsController::class, 'update']);

    // Favourites routes
    Route::get('/favourites', [FavouriteController::class, 'index']);
    Route::post('/favourites', [FavouriteController::class, 'store']);
    Route::delete('/favourites/{product_id}', [FavouriteController::class, 'destroy']);

    // AI Assistant routes (authenticated users - no rate limiting)
    Route::post('/assistant/chat', [AssistantController::class, 'chat']);
    Route::get('/assistant/history', [AssistantController::class, 'getHistory']);
    Route::delete('/assistant/history', [AssistantController::class, 'clearHistory']);
    Route::get('/assistant/suggestions', [AssistantController::class, 'getSuggestions']);
});

Route::get('/user', function (Request $request) {
    return $request->user();
})->middleware('auth:sanctum');
