<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag;

$__newAttributes = [];
$__propNames = \Illuminate\View\ComponentAttributeBag::extractPropNames(([
    'id',
    'type' => 'line',
    'data' => [],
    'height' => 300
]));

foreach ($attributes->all() as $__key => $__value) {
    if (in_array($__key, $__propNames)) {
        $$__key = $$__key ?? $__value;
    } else {
        $__newAttributes[$__key] = $__value;
    }
}

$attributes = new \Illuminate\View\ComponentAttributeBag($__newAttributes);

unset($__propNames);
unset($__newAttributes);

foreach (array_filter(([
    'id',
    'type' => 'line',
    'data' => [],
    'height' => 300
]), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
}

$__defined_vars = get_defined_vars();

foreach ($attributes->all() as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
}

unset($__defined_vars, $__key, $__value); ?>

<div class="relative" style="height: <?php echo e($height); ?>px">
    <canvas id="<?php echo e($id); ?>"></canvas>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const ctx = document.getElementById('<?php echo e($id); ?>').getContext('2d');
        const isDark = document.documentElement.classList.contains('dark');

        const chartData = <?php echo json_encode($data, 15, 512) ?>;

        const defaultOptions = {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    labels: {
                        color: isDark ? '#e5e7eb' : '#374151'
                    }
                }
            },
            scales: {}
        };

        if (['line', 'bar'].includes('<?php echo e($type); ?>')) {
            defaultOptions.scales = {
                y: {
                    beginAtZero: true,
                    ticks: {
                        color: isDark ? '#9ca3af' : '#6b7280'
                    },
                    grid: {
                        color: isDark ? '#374151' : '#e5e7eb'
                    }
                },
                x: {
                    ticks: {
                        color: isDark ? '#9ca3af' : '#6b7280'
                    },
                    grid: {
                        color: isDark ? '#374151' : '#e5e7eb'
                    }
                }
            };
        }

        new Chart(ctx, {
            type: '<?php echo e($type); ?>',
            data: chartData,
            options: defaultOptions
        });
    });
</script>
<?php /**PATH C:\xampp0\htdocs\octopus\resources\views/components/admin/chart.blade.php ENDPATH**/ ?>